//
// DESCRIPTION
// This program creates an XMLDocument object and writes it to a file.
// The encoding for the file is UTF-8.
//

import java.io.*;
import oracle.xml.parser.v2.*;
 
public class I18nSafeXMLFileWritingSample
{
   public static void main(String[] args) throws Exception
   {
      if (args.length == 0)
      {
         System.err.println("Usage: java I18nSafeXMLFileWritingSample <outfile>");
         System.exit(1);
      }

      // create a test document
      XMLDocument doc = new XMLDocument();
      doc.setVersion("1.0");
      doc.appendChild(doc.createComment("This is an empty test document."));
      doc.appendChild(doc.createElement("root"));
      
      // instantiate a File
      File file = new File(args[0]);
      
      // create a binary output stream to write to the file just created
      FileOutputStream fos = new FileOutputStream(file);
      
      // create a Writer that converts Java character stream to UTF-8 stream
      OutputStreamWriter osw = new OutputStreamWriter( fos,"UTF8");
      
      // buffering for efficiency
      Writer w = new BufferedWriter(osw);
      
      // create a PrintWriter to adapt to the printing method
      PrintWriter out = new PrintWriter(w);
      
      // print the document to the file through the connected objects
      doc.print(out);
   }
}
